//------------------------------------------------------------
// VelociBus_4X4BP Polled Buttons Example
// Turns on all LEDs in row & column of button pressed
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
VelociBus_4X4BP vbus; // create VelociBus interface, one required for each serial port used
#define VBUS_SERIAL Serial2

void setup() 
{
  Serial.begin(115200); // Serial monitor
  // button module on VeliciBus
  VBUS_SERIAL.begin(38400);    // VelociBus is always 38400
  // establish communication
  for (;;)
  { Serial.println("PROBING VelociBus...");
    if (vbus.begin( &VBUS_SERIAL )) break; // performs loopback diagnostic, tries 3 times, sets board_count
    delay(1000);
  }
  Serial.print("Found "); Serial.print(vbus.board_count); Serial.println(" Button Pad Modules");
  // all we want is press & release events
  vbus.setButtonHoldEnable( false ); // don't report long press events
}

void loop() 
{
  VelociBus_4X4BP::button_info btn;
  if (vbus.getButton( &btn ))
  {
    if (btn.event == VelociBus_4X4BP::BTN_PRESS)
    { // turn on all LEDs in button row
      vbus.setLEDrow( btn.board_address, btn.button_index / 4, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
      // turn on all LEDs in button column
      vbus.setLEDcol( btn.board_address, btn.button_index % 4, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
    }
    else // blank all LEDs on button release
      vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
  }
}
